% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dates_and_times.R
\name{full_days}
\alias{full_days}
\title{Drop incomplete days from a dataset}
\usage{
full_days(
  df,
  time_var = "Timestamp",
  drop = c("all", "leading", "trailing", "label"),
  epoch_length_sec = NULL,
  label_name = "is_full_day",
  digits = 6,
  check_continuous = TRUE,
  discontinuous_action = c("stop", "warn"),
  ...
)
}
\arguments{
\item{df}{the input data frame}

\item{time_var}{character scalar giving the column name of the variable
containing timestamp information (either \code{character} or \code{POSIXt}
format)}

\item{drop}{character scalar indicating which incomplete days to drop.
Can be \code{all} (default), \code{leading} (only day/s at the start of the
file), \code{trailing} (only day/s at the end of the file), or
\code{label}. If the latter is selected, the full dataset is returned with
an additional column indicating whether each row of data corresponds with a
complete day (useful for troubleshooting, among other things)}

\item{epoch_length_sec}{optional. The epoch length of the data. If no value
is passed, \code{\link{epoch_length_sec}} is invoked on the \code{time_var}
column}

\item{label_name}{character scalar. Name to give the indicator column when
\code{drop == "label"}}

\item{digits}{see \code{\link{epoch_length_sec}}}

\item{check_continuous}{logical. Check the dataframe after dropping to see if
it is continuous?}

\item{discontinuous_action}{character scalar telling what to do if a
discontinuity is expected when \code{check_continuous = TRUE}. Can be
either \code{warn} (the default) or \code{stop}}

\item{...}{arguments passed to \code{as.POSIXct}, for use if \code{time_var}
is a character rather than \code{POSIXt} variable}
}
\value{
an updated copy of \code{df}, in which incomplete days are addressed
  according to the selected value of \code{drop}.
}
\description{
Drop incomplete days from a dataset
}
\examples{
data(ex_data, package = "PAutilities")
ex_data <- full_days(
  ex_data, "DateTime", "label", 60,
  "full_day_indicator", tz = "UTC"
)
head(ex_data)
}
\seealso{
\code{\link{df_continuous}}
}
