% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/casecohort_secondary.R
\name{secondary_casecohort}
\alias{secondary_casecohort}
\title{Secondary analysis in case-cohort data}
\usage{
secondary_casecohort(SRS, CCH, NVsample, Z1.dim, Z2.dim, Z3.dim)
}
\arguments{
\item{SRS}{A data frame for subjects in the simple random sample. The first
column is T: observation time for time-to-event outcome. The second column
is Delta: the event indicator. The thid column is Y2: the continuous scale
secondary outcome. The fourth column is X: the expensive exposure. Starting
from the fifth column to the end are Z1, Z2 and Z3. Z1 is the set of
covariates that are included in the linear regression model of the
secondary outcome. Z2 is the set of covariates that are included in the Cox
model (the proportional hazards model which relates the primary failure
time to covariates). Z3 is the set of covariates that are related to the
conditional distribution of X given other covariates.}

\item{CCH}{A data frame for subjects in the case-cohort sample. The
case-cohort sample includes the simple random sample (SRS) and the
supplemental cases. The data structure is the same as SRS.}

\item{NVsample}{A data frame for subjects in the non-validation sample.
Subjects in the non-validation sample don't have the expensive exposure X
measured. The data structure is the following: The first column is T. The
second column is Delta. The thid column is Y2. Starting from the fourth
column to the end are Z1, Z2 and Z3.}

\item{Z1.dim}{Dimension of Z1.}

\item{Z2.dim}{Dimension of Z2.}

\item{Z3.dim}{Dimension of Z3. Note here that the algorithm requires Z3 to be
discrete and not high-dimensional, because we use the SRS sample to
estimate the conditional distribution of X given other covariates.}
}
\value{
A list which contains parameter estimates, estimated standard error
  for the primary outcome model: \deqn{\lambda
  (t)=\lambda_{0}(t)\exp{\gamma_{1}Y_{2}+\gamma_{2}X+\gamma_{3}Z2},}{lambda(t)=lambda0(t)exp{gamma1*Y2+gamma2*X+gamma3*Z2}}
   and the secondary outcome model:
  \deqn{Y_{2}=\beta_{0}+\beta_{1}X+\beta_{2}Z_{1}.}{Y2 = beta0 + beta1*X +
  beta2*Z1.} The list contains the following components:
  \item{gamma_paramEst}{parameter estimates for gamma in the primary outcome
  model} \item{gamma_stdErr}{estimated standard error for gamma in the
  primary outcome model} \item{beta_paramEst}{parameter estimates for beta in
  the secondary outcome model} \item{beta_stdErr}{estimated standard error
  for beta in the secondary outcome model}
}
\description{
\code{secondary_casecohort} performs the secondary analysis which describes
the association between a continuous secondary outcome and the expensive
exposure for case-cohort data.
}
\examples{
\donttest{
library(ODS)
# take the example data from the ODS package
# please see the documentation for details about the data set casecohort_data_secondary
data <- casecohort_data_secondary

# obtain SRS, CCH and NVsample from the original cohort data based on subj_ind
SRS <- data[data[,1]==1, 2:ncol(data)]
CCH <- data[data[,1]==1 | data[,1]==2, 2:ncol(data)]
NVsample <- data[data[,1]==0, 2:ncol(data)]

# delete the fourth column (columns for X) from the non-validation sample
NVsample <- NVsample[,-4]

Z1.dim <- 4
Z2.dim <- 3
Z3.dim <- 3
secondary_casecohort(SRS, CCH, NVsample, Z1.dim, Z2.dim, Z3.dim)
}
}
