\name{survtimes}
\alias{survtimes}
\docType{data}

\title{Survival Times of Guinea Pigs Infected with Tubercle Bacilli}

\description{
The \code{survtimes} data set contains the survival times (in days) of 72 guinea
pigs infected with virulent tubercle bacilli. These data were originally
reported by Bjerkedal (1960) in a study of the acquisition of resistance in
guinea pigs subjected to varying doses of tubercle bacilli.
}

\usage{
data(survtimes)
}

\format{
A numeric vector of length 72 giving the survival times (in days).
}

\value{
An object of class \code{"numeric"}.

The vector consists of 72 observed survival times (in days), each corresponding
to a single guinea pig experimentally infected with virulent tubercle bacilli.
Each value represents the number of days from infection to death or end of
observation. The dataset is commonly used in survival analysis and lifetime
modeling to illustrate time-to-event data, hazard behavior, and comparative
statistical methods.
}

\details{
This dataset represents experimentally observed survival durations of guinea
pigs infected with virulent tubercle bacilli. Survival analysis and lifetime
modeling studies commonly use this dataset as an example for illustrating
various statistical methodologies.
}

\references{
Bjerkedal, T. (1960).
\emph{Acquisition of Resistance in Guinea Pigs Infected with Different Doses of
Virulent Tubercle Bacilli}.
American Journal of Hygiene, 72(1), 130--148.
}

\examples{
data(survtimes)

# Basic summary
summary(survtimes)

# Plotting a simple histogram of survival times
hist(
  survtimes,
  main = "Survival Times of Guinea Pigs",
  xlab = "Days",
  col = "lightgray",
  border = "white"
)
}

\keyword{datasets}
