% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qq.plot.r
\name{qq.plot}
\alias{qq.plot}
\title{Generic Quantile-Quantile(Q-Q) Plot Function}
\usage{
qq.plot(sample, qfun, params, fit.line = FALSE)
}
\arguments{
\item{sample}{A numeric vector of sample observations.}

\item{qfun}{A quantile function corresponding to the theoretical distribution
(e.g., \code{qnorm}, \code{qexp}, or a custom quantile function).}

\item{params}{A named list of distribution parameters
(e.g., \code{list(mean = 0, sd = 1)} or \code{list(alpha = 2, lambda = 1)}).}

\item{fit.line}{Logical; if \code{TRUE} (default), a red least-squares
  regression line is added to the plot. Also, displays the regression
line equation and R-square value on the plot.}
}
\value{
This function returns no value; it produces a Q-Q plot.
}
\description{
Generates a Q-Q (quantile–quantile) plot for any custom or built-in
probability distribution. The function compares sample quantiles with
theoretical quantiles computed using a user-specified quantile function.
}
\details{
The function is general and can be used with any continuous distribution
for which a quantile function is available. It overlays both a 45° reference
line and (optionally) a fitted linear regression line through the points,
enabling visual assessment of model fit. Also, displays the regression
line equation and R² value on the plot. 

Requires user-defined function \code{'qfun'} for the CDF of the 
user-defined continuous distribution.

Missing values in the sample are automatically removed with a warning.
}
\examples{
# Example 1: Exponential distribution
set.seed(123)
x <- rexp(100, rate = 2)
qq.plot(x, qexp, list(rate = 2))

# Example 2: Customizing the fitted line
qq.plot(x, qexp, list(rate = 2),
              fit.line = TRUE)

# Example 3: Without regression line
qq.plot(x, qexp, list(rate = 2), fit.line = FALSE)

# Example 4: Display regression equation and R-square value
qq.plot(x, qexp, list(rate = 2), fit.line = TRUE)

# Example 5: For a user defined distribution
# Exponentiated Exponential Power (EEP) Distribution
#Data
x <- waiting
qq.plot(x,
      params = list(alpha=0.3407, lambda=0.6068, theta=7.6150),
      qfun = qgen.exp.power, fit.line=TRUE)

}
