% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoissonGPZ.r
\name{PoissonGPZ}
\alias{PoissonGPZ}
\alias{dpois.gpz}
\alias{ppois.gpz}
\alias{qpois.gpz}
\alias{rpois.gpz}
\alias{hpois.gpz}
\title{Poisson-Gompertz Distribution}
\usage{
dpois.gpz(x, alpha, beta, lambda, log = FALSE)
ppois.gpz(q, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
qpois.gpz(p, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
rpois.gpz(n, alpha, beta, lambda)
hpois.gpz(x, alpha, beta, lambda)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{beta}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dpois.gpz}: numeric vector of (log-)densities
  \item \code{ppois.gpz}: numeric vector of probabilities
  \item \code{qpois.gpz}: numeric vector of quantiles
  \item \code{rpois.gpz}: numeric vector of random variates
  \item \code{hpois.gpz}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Poisson-Gompertz distribution.
}
\details{
The Poisson-Gompertz distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\beta > 0}, and \eqn{\lambda > 0}.


The Poisson-Gompertz distribution has CDF:

\deqn{
F(x; \alpha, \beta, \lambda) =
\quad 1 - \frac{1}{{\left( {1 - {e^{ - \lambda }}} \right)}}
\left[ {1 - \exp \left\{ { - \lambda \exp \left( {\frac{\beta }{\alpha }
\left( {1 - {e^{\alpha x}}} \right)} \right)} \right\}} \right]  \quad ;\;x > 0.
}
 
where \eqn{\alpha}, \eqn{\beta}, and \eqn{\lambda} are the parameters.

The functions available are listed below:
\itemize{
  \item \code{dpois.gpz()} — Density function
  \item \code{ppois.gpz()} — Distribution function
  \item \code{qpois.gpz()} — Quantile function
  \item \code{rpois.gpz()} — Random generation
  \item \code{hpois.gpz()} — Hazard function
}
}
\examples{
x <- seq(0.1, 2.0, 0.2)
dpois.gpz(x, 2.0, 0.5, 0.2)
ppois.gpz(x, 2.0, 0.5, 0.2)
qpois.gpz(0.5, 2.0, 0.5, 0.2)
rpois.gpz(10, 2.0, 0.5, 0.2)
hpois.gpz(x, 2.0, 0.5, 0.2)

# Data
x <- stress
# ML estimates
params = list(alpha=0.2211, beta=0.6540, lambda=6.5456)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = ppois.gpz, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qpois.gpz, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dpois.gpz, pfun=ppois.gpz, plot=FALSE)
print.gofic(out)

}
\references{
Chaudhary,A.K., Sapkota,L.P., & Kumar, V. (2021). 
Poisson Gompertz Distribution with Properties and Applications. 
\emph{ International Journal of Applied Engineering Research (IJEAR)},
\bold{16(1)},75--84. \doi{10.37622/IJAER/16.1.2021.75-84}
}
