% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultANOVA.R
\name{MultANOVA}
\alias{MultANOVA}
\title{Multiple ANOVAs (MultANOVA)}
\usage{
MultANOVA(formula, design, responses, graph = TRUE, size.graph = 2.25)
}
\arguments{
\item{formula}{A formula with no left term that specify the model from the elements of the \strong{design} argument.}

\item{design}{A data.frame that contains only factors specifying the design on which rely the specified model of \strong{formula} argument.}

\item{responses}{A matrix or data.frame that contains only numerics or integers being the responses variables to be explained by the model from \strong{formula}.}

\item{graph}{A logical indicating whether or not multivariate type III r-squared by term must be plotted.}

\item{size.graph}{If \strong{graph=TRUE}, the overall size of labels and titles.}
}
\value{
An ANOVA-like table where each row corresponds to a term in the model or the residuals, the first column indicates the degrees of freedom, the second column corresponds to the multivariate type III r-squared and the third column corresponds to the p-value of the MultANOVA test.
}
\description{
Performs the MultANOVA omnibus test of each term from the model defined by \strong{formula} as defined in Mahieu & Cariou (2025).
}
\examples{
data(OTU)
an=MultANOVA(~Lot+Lactate+Atm+Time+Lactate:Atm+Lactate:Time,OTU[,1:4],OTU[,-c(1:4)])
print(an)
}
\references{
Mahieu, B., & Cariou, V. (2025). MultANOVA Followed by Post Hoc Analyses for Designed High‐Dimensional Data: A Comprehensive Framework That Outperforms ASCA, rMANOVA, and VASCA. Journal of Chemometrics, 39(7). \doi{https://doi.org/10.1002/cem.70039}
}
