% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recalculate.manual.R
\name{recalculate.manual}
\alias{recalculate.manual}
\title{Recalculate genomic values}
\usage{
recalculate.manual(
  population,
  gen = NULL,
  database = NULL,
  cohorts = NULL,
  e0 = NULL,
  e1 = NULL,
  e2 = NULL,
  store.comp.times = TRUE
)
}
\arguments{
\item{population}{Population list}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{database}{Groups of individuals to consider for the export}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{e0}{Effect matrix for 0 genotype (default: Will be automatically extracted)}

\item{e1}{Effect matrix for 1 genotype (default: Will be automatically extracted)}

\item{e2}{Effect matrix for 2 genotype (default: Will be automatically extracted)}

\item{store.comp.times}{If TRUE store computation times in $info$comp.times.general (default: TRUE)}
}
\value{
Population list
}
\description{
Function to recalculate genomic values
}
\examples{
data(ex_pop)
population <- recalculate.manual(ex_pop, gen = 1)
}
