# Manual check for plot.mrt_effect_size
# Run in an interactive R session.

library(MRTAnalysis)

# Ensure a single plotting panel
par(mfrow = c(1, 1))

# Example data
data("data_example_for_standardized_effect", package = "MRTAnalysis")

ans_ci <- calculate_mrt_effect_size(
  data = data_example_for_standardized_effect,
  id = "id",
  outcome = "outcome",
  treatment = "treatment",
  time = "decision_point",
  rand_prob = "prob_treatment",
  availability = "availability",
  covariates = "covariate1",
  do_bootstrap = TRUE,
  boot_replications = 100
)

summary(ans_ci)
plot(ans_ci)
