% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roc.R
\name{roc_curves}
\alias{roc_curves}
\alias{roc_curves.default}
\alias{roc_curves.mrmc}
\alias{roc_curves.stmc}
\alias{parameters}
\alias{parameters.roc_curve}
\alias{parameters.roc_curves}
\alias{parameters.mrmc}
\alias{parameters.stmc}
\alias{points.roc_curve}
\alias{points}
\alias{points.roc_curves}
\alias{points.empirical_curve}
\alias{points.empirical_curves}
\alias{mean.roc_curve}
\alias{mean}
\alias{mean.roc_curves}
\alias{mean.binormal_curves}
\title{ROC Performance Curves}
\usage{
roc_curves(...)

\method{roc_curves}{default}(truth, rating, groups = list(), method = "empirical", ...)

\method{roc_curves}{mrmc}(x, ...)

\method{roc_curves}{stmc}(x, ...)

parameters(x, ...)

\method{parameters}{roc_curve}(x, ...)

\method{parameters}{roc_curves}(x, ...)

\method{parameters}{mrmc}(x, ...)

\method{parameters}{stmc}(x, ...)

\method{points}{roc_curve}(
  x,
  metric = c("specificity", "sensitivity"),
  values = seq(0, 1, length = 101),
  ...
)

\method{points}{roc_curves}(
  x,
  metric = c("specificity", "sensitivity"),
  values = seq(0, 1, length = 101),
  ...
)

\method{points}{empirical_curve}(
  x,
  metric = c("specificity", "sensitivity"),
  values = NULL,
  which = c("curve", "curves", "observed"),
  ties = max,
  ...
)

\method{points}{empirical_curves}(
  x,
  metric = c("specificity", "sensitivity"),
  values = NULL,
  which = c("curve", "curves", "observed"),
  ties = max,
  ...
)

\method{mean}{roc_curve}(x, ...)

\method{mean}{roc_curves}(x, ...)

\method{mean}{binormal_curves}(x, method = c("points", "parameters"), ...)
}
\arguments{
\item{...}{arguments passed from the \code{mean()} method to \code{points()}.}

\item{truth}{vector of true binary statuses.}

\item{rating}{vector of numeric ratings.}

\item{groups}{list or data frame of grouping variables of the same lengths as
\code{truth} and \code{rating}.}

\item{method}{character string indicating the curve type as
\code{"binormal"}, \code{"binormalLR"}, \code{"empirical"}, or
\code{"trapezoidal"} or the averaging of binormal curves over
\code{"points"} or \code{"parameters"}.}

\item{x}{object returned by \code{\link{mrmc}} or \code{roc_curves} for which
to compute points on or to average over the curves.}

\item{metric}{reader performance metric to which the \code{values}
correspond.}

\item{values}{numeric vector of values at which to compute ROC curve points,
or \code{NULL} for default empirical values as determined by \code{which}.}

\item{which}{character string indicating whether to use curve-specific
observed values and 0 and 1 (\code{"curve"}), the combination of these
values over all curves (\code{"curves"}), or only the observed
curve-specific values (\code{"observed"}).}

\item{ties}{function determining empirical roc points returned in cases of
ties.}
}
\value{
Function \code{roc_curves} returns an \code{roc_curve} class object of a
single estimated ROC curve or an \code{roc_curves} class object of grouped
ROC curves.  Function \code{parameters} extracts the parameters that define
the curves, \code{points} returns a data frame of points on individual
curves, and \code{means} returns points on averaged curves (Chen and
Samuelson, 2014).
}
\description{
Calculation of ROC curve true positive rate (TPR) and false positive rate
(FPR) pairs for values of a numeric rating of a true binary response.
}
\examples{
curves <- with(VanDyke,
  roc_curves(truth, rating, groups = list(Test = treatment, Reader = reader))
)
points(curves)
mean(curves)

}
\references{
Chen W and Samuelson FW (2014). The average receiver operating characteristic
curve in multireader multicase imaging studies. The British Journal of
Radiology, 87(1040): 20140016.
}
\seealso{
\code{\link{plot}}
}
