% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot}
\alias{plot}
\alias{plot.roc_curve}
\alias{plot.roc_curves}
\alias{plot.empirical_curve}
\alias{plot.empirical_curves}
\alias{plot.roc_points}
\alias{plot.mrmc}
\alias{plot.stmc}
\title{ROC Plots}
\usage{
\method{plot}{roc_curve}(x, n = 100, emp_points = FALSE, ...)

\method{plot}{roc_curves}(x, n = 100, emp_points = FALSE, ...)

\method{plot}{empirical_curve}(x, ...)

\method{plot}{empirical_curves}(x, ...)

\method{plot}{roc_points}(x, coord_fixed = TRUE, ...)

\method{plot}{mrmc}(x, n = 100, ...)

\method{plot}{stmc}(x, n = 100, ...)
}
\arguments{
\item{x}{object to plot.}

\item{n}{number of equally spaced false-positive rate points at which to
calculate true-positive rates and interpolate through for display of the
curve.}

\item{emp_points}{logical indicating whether to overlay empirical ROC points
on parametric curves.}

\item{...}{arguments passed to other methods.}

\item{coord_fixed}{logical indicating whether to fix the scales of x and y
axes.}
}
\value{
Returns a \link[ggplot2]{ggplot} object.
}
\description{
Plots of ROC curves.
}
\examples{
curves <- with(VanDyke,
  roc_curves(truth, rating, groups = list(Test = treatment, Reader = reader))
)
plot(curves)

}
\seealso{
\code{\link{roc_curves}}
}
