% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cube-SplitDriveY.R
\name{cubeSplitDriveY}
\alias{cubeSplitDriveY}
\title{Inheritance Cube: Y-linked Split CRISPR Drive with 2 Resistance Alleles}
\usage{
cubeSplitDriveY(
  cM = 1,
  chM = 0,
  crM = 0,
  eta = NULL,
  phi = NULL,
  omega = NULL,
  xiF = NULL,
  xiM = NULL,
  s = NULL
)
}
\arguments{
\item{cM}{Cutting efficiency in males}

\item{chM}{Homing efficiency in males}

\item{crM}{Resistance efficiency in males}

\item{eta}{Genotype-specific mating fitness}

\item{phi}{Genotype-specific sex ratio at emergence}

\item{omega}{Genotype-specific multiplicative modifier of adult mortality}

\item{xiF}{Genotype-specific female pupatory success}

\item{xiM}{Genotype-specific male pupatory success}

\item{s}{Genotype-specific fractional reduction(increase) in fertility}
}
\value{
Named list containing the inheritance cube, transition matrix, genotypes, wild-type allele,
and all genotype-specific parameters.
}
\description{
This is a Y-linked version of a split CRISPR drive. At the Y-locus is the Cas9,
inherited in a Mendelian fashion. At a second, unlinked, autosomal locus are
the gRNAs. When the two loci occur together (i.e. in males), the gRNAs drive,
with potential damaged alleles, but the Cas9 remains Mendelian.
This drive has 2 loci:
\itemize{
\item "Locus" 1, sex chromosomes, has 3 alleles:
\itemize{
\item X: Wild-type X chromosome
\item Y: Wild-type Y chromosome
\item C: Y chromosome with Cas9
}
\item Locus 2, autosomal locus, has 4 alleles:
\itemize{
\item W: Wild-type allele
\item G: gRNA allele
\item R: Functional or low-cost resistance allele
\item B: Non-functional or high-cost resistance allele
}
}
}
