% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perceptron.R
\name{perceptron}
\alias{perceptron}
\title{Perceptron}
\usage{
perceptron(
  training_data,
  to_clasify,
  activation_method,
  max_iter,
  learning_rate,
  details = FALSE,
  waiting = TRUE
)
}
\arguments{
\item{training_data}{Data frame with already classified observations. Each
column represents a parameter of the values. The last column contains the
output, this means, the expected output when the other column values are
inputs. Each row is a different observation. It works as training data.}

\item{to_clasify}{Vector containing the parameters of the new value that we want to
classify.}

\item{activation_method}{Activation function to be used. It must be one of
\code{"step"}, \code{"sine"}, \code{"tangent"}, \code{"linear"}, \code{"relu"},
\code{"gelu"} or \code{"swish"}.}

\item{max_iter}{Maximum epoch during the training phase.}

\item{learning_rate}{Value at which the perceptron will learn from previous epochs mistakes.}

\item{details}{Boolean value. If it is set to "TRUE" multiple clarifications
and explanations are printed along the code}

\item{waiting}{If TRUE while \code{details} = TRUE. The code will stop in each
"block" of code and wait for the user to press "enter" to continue.}
}
\value{
List with the weights of the inputs.
}
\description{
Binary classification algorithm that learns to separate
two classes of data points by finding an optimal
decision boundary (hyper plane) in the feature space.
}
\details{
Functioning:

\describe{
\item{\emph{Step 1}}{Generate a random weight for each independent variable.}
\item{\emph{Step 2}}{Check if the weights classify correctly. If they do, go to step 4}
\item{\emph{Step 3}}{Adjust weights based on the error between the expected output and the real output.
If max_iter is reached go to step 4. If not, go to step 2.}
\item{\emph{Step 4}}{Return the weights and use them to classify the new value}
}
}
\examples{
# example code
perceptron(db_per_or, c(1, 1, 1), "gelu", 1000, 0.1)
perceptron(db_per_and, c(0,0,1), "swish", 1000, 0.1, TRUE, FALSE)

}
\author{
Víctor Amador Padilla, \email{victor.amador@edu.uah.es}
}
