% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_LTFHPlus_input.R
\name{prepare_LTFHPlus_input}
\alias{prepare_LTFHPlus_input}
\title{Prepares input for \code{estimate_liability}}
\usage{
prepare_LTFHPlus_input(
  .tbl,
  CIP,
  age_col,
  aoo_col,
  CIP_merge_columns = c("sex", "birth_year", "age"),
  CIP_cip_col = "cip",
  status_col = "status",
  use_fixed_case_thr = FALSE,
  fam_id_col = "fam_id",
  personal_id_col = "pid",
  interpolation = NULL,
  bst.params = list(max_depth = 10, base_score = 0, nthread = 4, min_child_weight = 10),
  min_CIP_value = 1e-05,
  xgboost_itr = 50
)
}
\arguments{
\item{.tbl}{contains family and personal ids and role with a family.}

\item{CIP}{tibble with population representative cumulative incidence proportions. CIP values should be merged by \code{CIP_columns}.}

\item{age_col}{name of column with age}

\item{aoo_col}{name of column with age of onset}

\item{CIP_merge_columns}{The columns the CIPs are subset by, e.g. CIPs by birth_year, sex.}

\item{CIP_cip_col}{name of column with CIP values}

\item{status_col}{Column that contains the status of each family member}

\item{use_fixed_case_thr}{Should the threshold be fixed for cases? Can be used if CIPs are detailed, e.g. stratified by birth_year and sex.}

\item{fam_id_col}{Column that contains the family ID}

\item{personal_id_col}{Column that contains the personal ID}

\item{interpolation}{type of interpolation, defaults to NULL.}

\item{bst.params}{list of parameters to pass on to xgboost}

\item{min_CIP_value}{minimum cip value to allow, too low values may lead to numerical instabilities.}

\item{xgboost_itr}{Number of iterations to run xgboost for.}
}
\value{
tibble formatted for \code{estimate_liability}
}
\description{
Prepares input for \code{estimate_liability}
}
\examples{
tbl = data.frame(
  fam_id = c(1, 1, 1, 1),
  pid = c(1, 2, 3, 4),
  role = c("o", "m", "f", "pgf"),
  sex = c(1, 0, 1, 1),
  status = c(0, 0, 1, 1),
  age = c(22, 42, 48, 78),
  birth_year = 2023 - c(22, 42, 48, 78),
  aoo = c(NA, NA, 43, 45))

cip = data.frame(
  age = c(22, 42, 43, 45, 48, 78),
  birth_year = c(2001, 1981, 1975, 1945, 1975, 1945),
  sex = c(1, 0, 1, 1, 1, 1),
  cip = c(0.1, 0.2, 0.3, 0.3, 0.3, 0.4))

prepare_LTFHPlus_input(.tbl = tbl,
                       CIP = cip, 
                       age_col = "age",
                       aoo_col = "aoo",
                       interpolation = NA)

}
