% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.L0TFinvfix}
\alias{plot.L0TFinvfix}
\alias{plot.L0TFinvopt}
\title{Plot L0TFinvfix or L0TFinvopt object}
\usage{
\method{plot}{L0TFinvfix}(x, type = NULL, k = NULL, ...)

\method{plot}{L0TFinvopt}(x, type = "mse", k = NULL, ...)
}
\arguments{
\item{x}{The output of L0TFinvfix or L0TFinvopt}

\item{type}{The values are taken as c("\eqn{mse}", "\eqn{sic}", "\eqn{bic}", "\eqn{yhat}"). If \eqn{type} is "\eqn{mse}", plot the mse as it changes with change points.
The same applies to "\eqn{sic}" and "\eqn{bic}". If \eqn{type} is "\eqn{yhat}", plot the trend of the estimated values against the input data.}

\item{k}{Only used for \eqn{type} = "\eqn{yhat}". The given number of change points.
By default, the L0TFinvfix object outputs the estimated trend that corresponds to the fixed number of change points within the model. Conversely, the L0TFinvopt object provides the estimated trend based on the optimal change points.}

\item{...}{ignore}
}
\value{
Plot the information criteria for L0TFinvfix and L0TFinvopt across an increasing number of change points or display the estimated trend with a selected change point
}
\description{
Plots a summary of L0TFinvfix or L0TFinvopt
}
\seealso{
\code{\link{print.L0TFinvfix}}
}
