% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{home_prices}
\alias{home_prices}
\title{House prices in King County WA}
\source{
The Center for Spatial Data Science, University of Chicago

\url{https://geodacenter.github.io/data-and-lab//KingCounty-HouseSales2015/}
}
\value{
\item{home_prices}{a tibble}
}
\description{
Housing data in Washington State from 2014-05-02 to 2015-05-27. There are
21,613 data points with columns:
}
\details{
\itemize{
\item \code{date_sold} (POSIXct): Date of sale
\item \code{price} (numeric): sale price (log10 units)
\item \code{bedrooms} (numeric): number of bedrooms
\item \code{bathrooms} (numeric): number of bathrooms
\item \code{sqft_living} (numeric): size of living space
\item \code{sqft_lot} (numeric): size of property
\item \code{floors} (numeric): number of floors
\item \code{waterfront} (numeric): binary indicator for a waterfront view
\item \code{view} (numeric): rating of the quality of the view
\item \code{condition} (factor): condition of the house (poor to very good)
\item \code{sqft_above} (numeric): size of living space above group
\item \code{sqft_basement} (numeric):size of living space below group
\item \code{yr_built} (numeric): year build
\item \code{year_renovated} (numeric): year renovated and, if not renovated, the year built
\item \code{zip_code} (factor): zip code
\item \code{latitude} (numeric): latitude
\item \code{longitude} (numeric): longitude
\item \code{nn_sqft_living} (numeric): size of living space of 15 neighbors
\item \code{nn_sqft_lot} (numeric):size of lot of 15 neighbors
}
}
\examples{

data(home_prices)
str(home_prices)
}
\keyword{datasets}
