% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_japan_population.R
\name{get_japan_population}
\alias{get_japan_population}
\title{Get Japan's Total Population from World Bank}
\source{
World Bank Open Data API: \url{https://data.worldbank.org/indicator/SP.POP.TOTL}
}
\usage{
get_japan_population()
}
\value{
A tibble with the following columns, or \code{NULL} if the API is unavailable:
\itemize{
  \item \code{indicator}: Indicator name (e.g., "Population, total")
  \item \code{country}: Country name ("Japan")
  \item \code{year}: Year of the data (integer)
  \item \code{value}: Population as a numeric value
  \item \code{value_label}: Formatted population with commas (e.g., "126,000,000")
}
}
\description{
Retrieves Japan's total population for the years 2010 to 2022
using the World Bank Open Data API. The indicator used is \code{SP.POP.TOTL}.
}
\details{
The function sends a GET request to the World Bank API.
If the API request fails or returns an error status code, the function returns \code{NULL} with an informative message.
}
\note{
Requires internet connection. The data is retrieved in real time from the World Bank API.
}
\examples{
\donttest{
# Requires internet connection
result <- get_japan_population()
if (!is.null(result)) {
  print(result)
}
}

}
\seealso{
\code{\link[httr]{GET}}, \code{\link[jsonlite]{fromJSON}}, \code{\link[dplyr]{as_tibble}}, \code{\link[scales]{comma}}
}
