% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_japan_life_expectancy.R
\name{get_japan_life_expectancy}
\alias{get_japan_life_expectancy}
\title{Get Japan's Life Expectancy at Birth from World Bank}
\source{
World Bank Open Data API: \url{https://data.worldbank.org/indicator/SP.DYN.LE00.IN}
}
\usage{
get_japan_life_expectancy()
}
\value{
A tibble with the following columns, or \code{NULL} if the API is unavailable:
\itemize{
  \item \code{indicator}: Indicator name (e.g., "Life expectancy at birth, total (years)")
  \item \code{country}: Country name ("Japan")
  \item \code{year}: Year of the data (integer)
  \item \code{value}: Life expectancy value in numeric form (years)
}
}
\description{
Retrieves Japan's life expectancy at birth (in years) for the years 2010 to 2022
using the World Bank Open Data API. The indicator used is \code{SP.DYN.LE00.IN}.
}
\details{
The function sends a GET request to the World Bank API.
If the API request fails or returns an error status code, the function returns \code{NULL} with an informative message.
}
\note{
Requires internet connection. The data is retrieved in real time from the World Bank API.
}
\examples{
\donttest{
# Requires internet connection
result <- get_japan_life_expectancy()
if (!is.null(result)) {
  print(result)
}
}

}
\seealso{
\code{\link[httr]{GET}}, \code{\link[jsonlite]{fromJSON}}, \code{\link[dplyr]{as_tibble}}
}
