% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SelectEffectivenessOfSolution.R
\name{SelectEffectivenessOfSolution}
\alias{SelectEffectivenessOfSolution}
\title{Determine the pair by pair effects that are important for the analysis.}
\usage{
SelectEffectivenessOfSolution(EffectivenessOfSolution)
}
\arguments{
\item{EffectivenessOfSolution}{Output generated by the function  `EffectivenessOfSolution`}
}
\value{
Returns a vector with logical values demonstrating the
interactions considered important for the analysis.
}
\description{
Selects, pair by pair, the effect of S.S. on L.S.
}
\examples{
library(ImportanceIndice)
data("DataLossSource")
data("DataSolutionSource")
data("DataProduction")
data("DataNumberSamples")

Distribution_LossSource(DataLossSource)
Distribution_SolutionSource(DataSolutionSource)

#################################################
###################################################



LS<-LossSource(DataLoss = DataLossSource,DataProd = DataProduction)
LS

LP<-LossProduction(Data=DataLossSource,Prod = DataProduction,
                 Evaluation=DataNumberSamples,
                 SegurityMargen=0.75,MaximumToleranceOfLossFruits=1)
LP


ES<-EffectivenessOfSolution(DataLossSource=DataLossSource,
                          DataSolutionSource=DataSolutionSource,Production =DataProduction)
ES




id<-SelectEffectivenessOfSolution(ES)
id<-c(TRUE , TRUE,  TRUE , FALSE,  TRUE)


SS<-SolutionSource(SolutionData = DataSolutionSource,
                 EffectivenessOfSolution = ES,Production = DataProduction,Id = id)
SS


NAL<-NonAttentionLevel(EffectivenessOfSolution = ES,LossProduction = LP,Id = id,Verbose=TRUE)
NAL
}
\seealso{
\code{\link{EffectivenessOfSolution}} ,  \code{\link{NonAttentionLevel}}  ,  \code{\link{LossSource}}
}
\author{
Germano Leao Demolin-Leite (Instituto de Ciencias Agrarias da UFMG) \cr
Alcinei Mistico Azevedo (Instituto de Ciencias Agrarias da UFMG)
}
