% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constrained_IRT.R
\name{M_constrained_irt}
\alias{M_constrained_irt}
\title{M_constrained_irt}
\usage{
M_constrained_irt(
  Y,
  d,
  M = NULL,
  theta_fix = NULL,
  which_fix = NULL,
  nburn = 1000,
  nsamp = 1000,
  thin = 10,
  learn_Sigma = TRUE,
  learn_Omega = FALSE,
  hyperparameters = list(),
  display_progress = TRUE
)
}
\arguments{
\item{Y}{a N x K matrix of responses given by N respondents to K items. Can contain missing values.}

\item{d}{an integer specifying the number of latent dimensions.}

\item{M}{a list of K d x d matrices (default=NULL).}

\item{theta_fix}{a matrix with d columns containing the values of the latent dimensions for respondents that have pre-specified latent factors.}

\item{which_fix}{a vector containing the indices of the respondents for which latent factors have been fixed.}

\item{nburn}{an integer specifying the number of burn-in MCMC iterations.}

\item{nsamp}{an integer specifying the number of sampling MCMC iterations.}

\item{thin}{an integer specifying the number of thinning MCMC samples.}

\item{learn_Sigma}{a Boolean specifying whether a covariance matrix for the latent factors should be learned.}

\item{learn_Omega}{a Boolean specifying whether a covariance matrix for the latent loadings should be learned.}

\item{hyperparameters}{a list of hyperparameters for the model.}

\item{display_progress}{a Boolean specifying whether a progress bar should be displayed.}
}
\value{
A list containing the following components:
\item{lambda}{An array of dimension (K x d x nsamp/thin) containing posterior samples of item discrimination parameters.}
\item{b}{A matrix of dimension (K x nsamp/thin) containing posterior samples of item difficulty parameters.}
\item{theta}{An array of dimension (N x d x nsamp/thin) containing posterior samples of respondent latent trait values.}
\item{Sigma}{An array of dimension (d x d x nsamp/thin) containing posterior samples of the covariance matrix of latent traits (only if learn_Sigma=TRUE).}
\item{Omega}{An array of dimension (d x d x nsamp/thin) containing posterior samples of the covariance matrix of item loadings (only if learn_Omega=TRUE).}
}
\description{
This function allows you to run the IRT model.
}
