% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_regress.R
\name{linear_regress}
\alias{linear_regress}
\title{Linear regression summary}
\usage{
linear_regress(formula, data, level = 0.99)
}
\arguments{
\item{formula}{A formula like Y ~ X1 + X2}

\item{data}{A data frame}

\item{level}{Confidence level (default 0.99)}
}
\value{
Object of class 'linear_regress'
}
\description{
This function performs a linear regression and returns a summary including:
\itemize{
\item Adjusted R-squared
\item Overall F-test p-value
\item Table with parameter estimates, confidence intervals (default 99\%), p-values, and significance stars (*, **, ***)
}
}
\examples{
data(Housing, package = "IPAG")
linear_regress(MEDV ~ RM + LSTAT, data = Housing)

}
