% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence_context_functions.R
\name{SymmetricalContextsFor1BPIndel}
\alias{SymmetricalContextsFor1BPIndel}
\title{Get all the sequence contexts of the indels in a given 1 base-pair indel
class from a VCF}
\usage{
SymmetricalContextsFor1BPIndel(annotated.vcf, indel.class, flank.length = 5)
}
\arguments{
\item{annotated.vcf}{An in-memory \code{data.frame} or similar table
containing "VCF" (variant call format) data as created by
\code{\link{VCFsToIDCatalogs}}
 with argument \code{return.annotated.vcfs = TRUE}.}

\item{indel.class}{A single character string that denotes a 1 base pair
insertion or deletion, as taken from \code{ICAMS::catalog.row.order$ID}.
Insertions or deletions into or from 5+ base-pair homopolymers are not
supported.}

\item{flank.length}{The length of flanking bases around the position or
homopolymer targeted by the indel.}
}
\value{
A list of all sequence contexts for the specified \code{indel.class}.
}
\description{
Get all the sequence contexts of the indels in a given 1 base-pair indel
class from a VCF
}
\keyword{internal}
