% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence_context_functions.R
\name{CreateOnePPMFromSBSVCF}
\alias{CreateOnePPMFromSBSVCF}
\title{Create position probability matrix (PPM) for *one* sample from
a Variant Call Format (VCF) file.}
\usage{
CreateOnePPMFromSBSVCF(vcf, ref.genome, seq.context.width)
}
\arguments{
\item{vcf}{One in-memory data frame of pure SBS mutations -- no DBS or 3+BS
mutations.}

\item{ref.genome}{A \code{ref.genome} argument as described in
\code{\link{ICAMS}}.}

\item{seq.context.width}{The number of preceding and following bases to be
extracted around the mutated position from \code{ref.genome}.}
}
\value{
A position probability matrix (PPM).
}
\description{
Create position probability matrix (PPM) for *one* sample from
a Variant Call Format (VCF) file.
}
\keyword{internal}
