% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{hic2network}
\alias{hic2network}
\title{HiC to network data format}
\usage{
hic2network(ftab)
}
\arguments{
\item{ftab}{three-column data composed of locus1, locus2 and value}
}
\value{
An \code{igraph} object representing statistically significant chromatin interactions.
}
\description{
It converts Hi-C dataframe to network object.
}
\details{
Convert HiC to network data format
}
\examples{
# This example might take a long time to run, so we wrap it in donttest{}
\donttest{
myhic=system.file('extdata', 'example.hic', package ='HiCocietyExample')
ftab=getContactFrequency(myhic,19,5000);
net = hic2network(ftab[1:100,]);
plot(net)
}
}
\author{
Sora Yoon, PhD
}
