% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls.R
\name{pls}
\alias{pls}
\alias{pls.default}
\title{Partial Least Squares (PLS) for HDANOVA}
\usage{
pls(object, ...)

\method{pls}{default}(object, ...)
}
\arguments{
\item{object}{A \code{hdanova} object.}

\item{...}{Additional arguments (not used).}
}
\value{
An updated \code{hdanova} object with PLS results.
}
\description{
This function performs Partial Least Squares (PLS) on a \code{hdanova}.
}
\details{
For residuals, PCA is performed instead of PLS as there is no natural response.
}
\examples{
# Load candies data
data(candies)

# Basic HDANOVA model with two factors
mod <- hdanova(assessment ~ candy + assessor, data=candies)
mod <- pls(mod)
scoreplot(mod)

}
