% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hadamard_search.R
\name{hadamardExperimentalDesign}
\alias{hadamardExperimentalDesign}
\title{Create a Hadamard Design}
\usage{
hadamardExperimentalDesign(X, strict = TRUE, form = "one_zero")
}
\arguments{
\item{X}{The design matrix with $n$ rows (one for each subject) and $p$ columns 
(one for each measurement on the subject). The measurements aren't used to
compute the Hadamard designs, only the number of rows.}

\item{strict}{Hadamard matrices are not available for all $n$.}

\item{form}{Which form should it be in? The default is \code{one_zero} for 1/0's or \code{pos_one_min_one} for +1/-1's.}
}
\value{
An matrix of dimension $R$ x $n$ where $R$ is the number of Hadamard allocations.
}
\description{
This method returns unique designs according to a Hadamard matrix. For debugging, you can use \code{set.seed}
to be assured of deterministic output.
}
\examples{
\dontrun{
set.seed(1)
X = matrix(rnorm(16), nrow = 8)
W = hadamardExperimentalDesign(X, strict = TRUE, form = "one_zero")
dim(W)
}
}
\author{
Adam Kapelner
}
