% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StatGOU.R
\name{StatGOU}
\alias{StatGOU}
\title{Change-point tests for generalized Ornstein-Uhlenbec (GOU) process}
\usage{
StatGOU(X, T1, N, p, q, gamma, c1, cd)
}
\arguments{
\item{X}{observations}

\item{T1}{last time of observation}

\item{N}{number of observations on from on interval (0,T1]}

\item{p}{number of cosine coefficients >=1}

\item{q}{number of sine coefficients >=0}

\item{gamma}{weight parameter >=0 and < 0.5}

\item{c1}{critical value for Q stat (based on 1-dimensional weigthed BM)}

\item{cd}{critical value for G stat (based on d-dimensional weigthed BM), where d = p+q+1 is the number of estimated parameters for the drift.}
}
\value{
\item{out}{List }
}
\description{
Function to simulate exact N+K+1 values with change point after N+K_star, with  K_star = floor(N*t_star), for a GOU process. Starting point is 0.
}
\examples{
T1=20
N=500
gamma = 0.1
p=2
q=0
c1 = 2.2838 # corresponding to gamma=0.1
c3 = 3.0502 # corresponding to gamma=0.1 and d=3 estimated parameters for the drift
data(X)
out=StatGOU(X,T1,N,p,q,gamma,c1,c3)
}
\references{
Lyu, Nasri and Remillard (2025): Sequential Change-point Detection with Generalized Ornstein–Uhlenbeck Processes
}
