% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ForecastHMMeta.R
\name{ForecastHMMeta}
\alias{ForecastHMMeta}
\title{Predicted probabilities of regimes of a univariate HMM for a new observation}
\usage{
ForecastHMMeta(ynew, ZI = 0, family, theta, Q, eta)
}
\arguments{
\item{ynew}{new observations}

\item{ZI}{1 if zero-inflated, 0 otherwise (default)}

\item{family}{distribution name; run the function distributions() for help}

\item{theta}{parameters; (r  x p)}

\item{Q}{probability transition  matrix for the regimes; (r  x r)}

\item{eta}{vector of the estimated probability of each regime at time n; (1  x r)}
}
\value{
\item{etanew}{predicted probabilities of the regimes}
}
\description{
This function computes the predicted probabilities of the regimes for a new observation of a univariate HMM, given observations up to time n
}
\examples{
family = "gaussian"
theta = matrix(c(-1.5, 1.7, 1, 1),2,2)
Q = matrix(c(0.8, 0.3, 0.2, 0.7), 2, 2)
eta = c(0.96, 0.04)
ForecastHMMeta(1.5, 0, family, theta, Q, eta)

}
