#' RIG-DD Test
#'
#' Performs the RIG-DD test of randomness.
#'
#' @param x A numeric vector corresponding to interval of an RIG.
#' @return Vector of test statistics of RIG-DD Test.
#' @examples
#' x <- arima.sim(model = list(ar=c(0.7,0.2)), 1000) ## AR(2) model
#' rigdd.test(x)
#' @export
rigdd.test <- function(x) {
  m <- length(x)
  nv <- m %/% 2
  r <- m %% 2
  cdf_t <- cdf.rig(m)
  HD <- numeric(r + 1)
  for (i in 1:(r + 1)) {
    x_r <- x[i:(2 * nv + i - 1)]
    deg <- deg.rig(x_r)
    cdf <- sapply(1:nv, function(j) sum(deg <= j) / nv)
    HD[i] <- hellinger.dist(cdf, cdf_t)
  }
  structure(list(
    statistic = HD,
    method     = "RIG-DD Test",
    data.name  = deparse(substitute(x))
  ),
  class = "rigdd")
}
