% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRCdesigns.R
\name{SCGRC_II}
\alias{SCGRC_II}
\title{Structurally Complete Generalized Row Column Designs of Series-II}
\usage{
SCGRC_II(v)
}
\arguments{
\item{v}{Even number(>3)}
}
\value{
This function generates structurally complete GRC designs for even number of treatment as well as the information matrix for estimating elementary treatment contrast.
}
\description{
This series generated through initial columns. The parameters of the design are v, p = (v-1) rows of size v, q =v/2 columns of size 2(v-1), k = 2 and r = (v-1).
}
\examples{
library(GRCdesigns)
SCGRC_II(6)
}
\references{
1) Datta, A., Jaggi, S., Varghese, C. and Varghese, E. (2014). Structurally incomplete row-column designs with multiple units per cell. Statistics and Applications, 12(1&2), 71-79.

2)Datta, A., Jaggi, S., Varghese, C. and Varghese, E. (2015). Some series of row-column designs with multiple units per cell. Calcutta Statistical Association Bulletin, 67, ( 265-266), 89-99.

3)Datta, A., Jaggi, S., Varghese, C. and Varghese, E.  (2016). Series of incomplete row-column designs with two units per cell. Advances in Methodology and Statistics. 13(1), 17-25.
}
