% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GIFT_env.R
\name{GIFT_env}
\alias{GIFT_env}
\title{Environmental data for GIFT checklists}
\usage{
GIFT_env(
  entity_ID = NULL,
  miscellaneous = if (is.null(rasterlayer)) "area" else NULL,
  rasterlayer = NULL,
  sumstat = "mean",
  GIFT_version = "latest",
  api = "https://gift.uni-goettingen.de/api/extended/"
)
}
\arguments{
\item{entity_ID}{A vector defining the ID of the lists to retrieve.
\code{NULL} by default, in that case, every list from GIFT is retrieved.}

\item{miscellaneous}{character vector or list specifying the miscellaneous
data to retrieve. . A list of all miscellaneous layers for which precomputed
information exists in the database can be viewed in the output table
returned by \code{GIFT_env_meta_misc()}.}

\item{rasterlayer}{character vector or list specifying the raster
data to retrieve. A list of all raster layers for which precomputed
information exists in the database can be viewed in the output table
returned by \code{GIFT_env_meta_raster()}.}

\item{sumstat}{Vector or list indicating the desired summary statistics out
of \code{c("min", "q05", "q10", "q20", "q25", "q30", "q40", "med", "q60", "q70",  "q75", "q80", "q90", "q95", "max", "mean", "sd", "modal", "unique_n", "H",  "n")} used to aggregate the information coming from the raster layers. If
\code{sumstat} is a vector, the same summary statistics are used for all raster
layers. If \code{sumstat} is a list, the first element defines the summary
statistics for the first raster layer, the second for the second and so
on.\cr

\strong{Important note}\cr Some summary statistics may not be informative
depending on the environmental layer you ask for. For example, it is not
relevant to retrieve the mean of soil classes for a polygon. The mode or
Shannon index are more suitable in that case.}

\item{GIFT_version}{character string defining the version of the GIFT
database to use. The function retrieves by default the \code{latest} stable
version. If set to \code{beta}, the most up-to-date version which is still
subject to changes and edits is used.}

\item{api}{character string defining from which API the data will be
retrieved.}
}
\value{
A data frame with the environmental values per polygon (entity_ID).
}
\description{
Retrieve environmental data associated to each GIFT checklists.
Sources of environmental variables can come from raster layers or
from shape files (miscellaneous). Users need to define what variables they
are interested in and then ask for a set of summary statistics (in case of
raster layers).
}
\details{
The columns of the data.frame are the following:

\emph{entity_ID} - Identification number of the polygon\cr
\emph{geo_entity} - Name of the polygon\cr
The other columns relate to the environmental variables the user asked for.
}
\examples{
\donttest{
ex <- GIFT_env(entity_ID = c(1,5),
               miscellaneous = c("perimeter", "biome"),
               rasterlayer = c("mn30_grd", "wc2.0_bio_30s_01"),
               sumstat = list(c("mean", "med"), "max"))
}

}
\references{
\if{html}{\out{<div class="sourceCode">}}\preformatted{ Denelle, P., Weigelt, P., & Kreft, H. (2023). GIFT—An R package to
 access the Global Inventory of Floras and Traits. Methods in Ecology
 and Evolution, 14, 2738-2748.
 https://doi.org/10.1111/2041-210X.14213

 Weigelt, P, König, C, Kreft, H. GIFT – A Global Inventory of Floras and
 Traits for macroecology and biogeography. J Biogeogr. 2020; 47: 16– 43.
 https://doi.org/10.1111/jbi.13623
}\if{html}{\out{</div>}}
}
\seealso{
\code{\link[=GIFT_env_meta_misc]{GIFT_env_meta_misc()}} and \code{\link[=GIFT_env_meta_raster]{GIFT_env_meta_raster()}}
}
