#' Simulate GARCHX model
#'
#' Simulates Time series data from GARCH model with exogenous covariates
#'
#' @param n Desired length of simulated time series data
#' @param omega Coefficient value for omega, required to be \deqn{\omega_0 > 0}
#' @param alpha ARCH Coefficient value, required to be \deqn{\alpha_0 \geq 0}
#' @param beta GARCH Coefficient value, required to be \deqn{\beta_0 \geq 0}
#' @param X Matrix with exogenous covariates where the number of rows is equal to the length of n + valinit
#' @param pi Vector containing coefficients for exogenous covariates.
#' @param delta Value of the power of the time series to allow for Power GARCHX, default is 2 for GARCHX
#' @param shock.distr Distribution of the shock eta_t that multiply w_t in the GARCH-X model eps_ = w_t*eta_t
#' @param valinit Initialization value, default value is 200
#'
#' @return A named list containing vector of Time Series data and X covariates used
#' @export
#'
#' @examples n <- 200
#' @examples d <- 4
#' @examples valinit <- 100
#' @examples n2 <- n + d + 1
#' @examples omega <- 0.05
#' @examples alpha <- 0.05
#' @examples beta <- 0.05
#' @examples delta <- 2
#' @examples pi <- rep(0.05, d)
#' @examples e<-rnorm(n2+valinit)
#' @examples Y<-e
#' @examples for (t in 2:n2)
#' @examples  Y[t]<- 0.2*Y[t-1]+e[t]
#' @examples x<-exp(Y)
#' @examples X <- matrix(0, nrow = (n+valinit), ncol = length(pi))
#' @examples for(j in 1:d)
#' @examples  X[, j] <- x[(d+2-j):(n+d+1-j+valinit)]
#' @examples data <- simulate(n, omega, alpha, beta, delta, X, pi, valinit = valinit)
simulate <- function(n, omega, alpha, beta, delta = 2, X, pi, shock.distr = "Normal", valinit = 200){
  UseMethod("simulate")
} # End simulate
