nadaraya_watson_multivariate <- function(X, Y, x, bandwidth){

  # Check if length of x is same as number of exogenous covariates
  if(ncol(X) != length(x)){
    stop("THe dimension of 'x' must match the number of columns in 'X'")
  }

  kernel_weights <- get_kernel_weights(X, x, bandwidth)

  normalized_weights <- kernel_weights / sum(kernel_weights)

  estimate <- sum(normalized_weights * Y)

  return(estimate)
} # End nadaraya_watson_multivariate
