% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional_calibration_wavelets.R
\name{functional_calibration_wavelets}
\alias{functional_calibration_wavelets}
\title{Functional Data Calibration with Wavelets}
\usage{
functional_calibration_wavelets(
  data,
  weights,
  wavelet = "DaubExPhase",
  method = "bayesian",
  tau = 1,
  p = NULL,
  sigma = NULL,
  MC = FALSE,
  type = "soft",
  singular = FALSE,
  x = NULL
)
}
\arguments{
\item{data}{A matrix \eqn{M} x \eqn{I} where each column represents one sample of the aggregated function — the matrix \eqn{A} in the model.}

\item{weights}{A matrix \eqn{L} x \eqn{I} representing the weight values associated with each sample — the matrix \eqn{y} in the model.}

\item{wavelet}{A string indicating the wavelet family to be used in the Discrete Wavelet Transform (DWT).}

\item{method}{A string specifying the shrinkage method applied to the empirical wavelet coefficients. Options are: "bayesian", "universal", "sure", "probability", or "cv".}

\item{tau}{A numeric value for the \eqn{\tau} parameter in the Bayesian shrinkage. If \code{NULL}, it is estimated from the data.}

\item{p}{A numeric value for the \eqn{p} parameter in the Bayesian shrinkage. If \code{NULL}, it is estimated from the data.}

\item{sigma}{A numeric value for the \eqn{\sigma} parameter in the Bayesian shrinkage. If \code{NULL}, it is estimated from the data.}

\item{MC}{A logical evaluating to \code{TRUE} or \code{FALSE} indicating if the integrals in the Bayesian shrinkage are approximated using Monte Carlo simulation.}

\item{type}{A string indicating whether the thresholding should be "soft" or "hard" (applies only when the method is not "bayesian").}

\item{singular}{A logical evaluating to \code{TRUE} or \code{FALSE} indicating if it adds a small constant (1e-10) to the diagonal of \eqn{yy^T} to stabilize the matrix inversion.}

\item{x}{A numeric vector of values at which the function is evaluated. If \code{NULL}, the default is the sequence \code{1:nrow(data)}.}
}
\value{
The function returns a list containing two objects:

\describe{
  \item{\code{alpha}}{A matrix with the estimated functional coefficients \eqn{\alpha}.}
  \item{\code{Plots}}{A list of plot objects, each representing the corresponding function \eqn{\alpha_l(x)}.}
}
}
\description{
This function performs functional calibration based on the following model:

\deqn{A_i(x_m) = \displaystyle \sum_{l=1}^{L} y_{il} \alpha_l(x_m) + e_i(x_m), \quad i = 1,...,I, \quad m = 1,...,M = 2^J}

where the functions \eqn{\alpha_l(x)} are estimated using wavelet decomposition.

In matrix notation, the model is represented as:

\deqn{A = \alpha y + e}
}
\examples{
\donttest{functional_calibration_wavelets(simulated_data$data, simulated_data$weights)}
\donttest{functional_calibration_wavelets(simulated_data$data, simulated_data$weights,
                                tau = 5, p = 0.95, sigma = 0.1, x = simulated_data$x)}
functional_calibration_wavelets(simulated_data$data, simulated_data$weights,
                                method = "universal")

}
\references{
dos Santos Sousa, A. R. (2024). A wavelet-based method in aggregated functional data analysis. Monte Carlo Methods and Applications, 30(1), 19-30.
}
