% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fracfixr.r
\name{FracFixR}
\alias{FracFixR}
\title{FracFixR: Main Function for Fraction Correction}
\usage{
FracFixR(MatrixCounts, Annotation, parallel = TRUE)
}
\arguments{
\item{MatrixCounts}{A numeric matrix of raw transcript/gene counts with:
\itemize{
  \item Rows: transcripts/genes (must have rownames)
  \item Columns: samples (must have colnames matching Annotation$Sample)
}}

\item{Annotation}{A data.frame with required columns:
\itemize{
  \item Sample: sample identifiers matching column names in MatrixCounts
  \item Condition: experimental condition (e.g., "Control", "Treatment")
  \item Type: fraction type (must include at least one "Total")
  \item Replicate: replicate identifier
}}

\item{parallel}{A boolean indicating whether to use parallel processing of
the transcripts (default=TRUE).}
}
\value{
A list containing:
  \itemize{
    \item OriginalData: filtered input count matrix
    \item Annotation: input annotation data
    \item Propestimates: matrix of proportion estimates
    \item Coefficients: data.frame of regression coefficients
    \item Fractions: data.frame of estimated fraction proportions
    \item plots: list of diagnostic plots
  }
}
\description{
This is the core function that implements the FracFixR framework. It takes
raw count data from total and fractionated samples and reconstructs the
original fraction proportions through compositional modeling.
}
\details{
The function works by:
\enumerate{
  \item Filtering transcripts based on presence in Total samples
  \item For each condition and replicate, fitting NNLS regression
  \item Estimating global fraction weights and individual transcript proportions
  \item Calculating the "lost" unrecoverable fraction
}
}
\examples{
# Load example data
data(example_counts)
data(example_annotation)

# Run FracFixR
results <- FracFixR(example_counts, example_annotation, parallel=FALSE)

# View fraction proportions
print(results$Fractions)

}
\references{
Cleynen et al. FracFixR: A compositional statistical framework for
absolute proportion estimation between fractions in RNA sequencing data.
}
