% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/middleout.R
\name{ctmo}
\alias{ctmo}
\title{Cross-temporal middle-out reconciliation}
\usage{
ctmo(base, agg_mat, agg_order, id_rows = 1, order = max(agg_order),
     weights, tew = "sum", normalize = TRUE)
}
\arguments{
\item{base}{A (\eqn{n_l \times hk}) numeric matrix containing the \eqn{l}-level
base forecasts of temporal aggregation order \eqn{k}; \eqn{n_l} is the number of variables at
level \eqn{l}, \eqn{k} is an aggregation order (a factor of \eqn{m}, and \eqn{1<k<m}),
\eqn{m} is the max aggregation order, and \eqn{h} is the forecast horizon for the
lowest frequency time series.}

\item{agg_mat}{A (\eqn{n_a \times n_b}) numeric matrix representing the cross-sectional
aggregation matrix. It maps the \eqn{n_b} bottom-level (free)
variables into the \eqn{n_a} upper (constrained) variables.}

\item{agg_order}{Highest available sampling frequency per seasonal cycle (max. order
of temporal aggregation, \eqn{m}), or a vector representing a subset of \eqn{p} factors
of \eqn{m}.}

\item{id_rows}{A numeric vector indicating the \eqn{l}-level rows of \code{agg_mat}.}

\item{order}{The intermediate fixed aggregation order \eqn{k}.}

\item{weights}{A (\eqn{n_b \times hm}) numeric matrix containing the proportions for each
high-frequency bottom time series; \eqn{n_b} is the total number of high-frequency
bottom variables, \eqn{m} is the max aggregation order, and \eqn{h} is the forecast horizon
for the lowest frequency time series.}

\item{tew}{A string specifying the type of temporal aggregation. Options include:
"\code{sum}" (simple summation, \emph{default}), "\code{avg}" (average),
"\code{first}" (first value of the period), and "\code{last}"
(last value of the period).}

\item{normalize}{If \code{TRUE} (\emph{default}), the \code{weights} will sum to 1.}
}
\value{
A (\eqn{n \times h(k^\ast+m)}) numeric matrix of cross-temporal reconciled forecasts.
}
\description{
The cross-temporal middle-out forecast reconciliation combines top-down
(\link{cttd}) and bottom-up (\link{ctbu}) methods in the cross-temporal framework for
genuine hierarchical/grouped time series. Given the base forecasts of an
intermediate cross-sectional level \eqn{l} and aggregation order \eqn{k},
it performs
\itemize{
\item a top-down approach for the aggregation orders \eqn{\geq k} and
cross-sectional levels \eqn{\geq l};
\item a bottom-up approach, otherwise.
}
}
\examples{
set.seed(123)
# Aggregation matrix for Z = X + Y, X = XX + XY and Y = YX + YY
A <- matrix(c(1,1,1,1,1,1,0,0,0,0,1,1), 3, byrow = TRUE)
# (2 x 6) base forecasts matrix (simulated), forecast horizon = 3
# and intermediate aggregation order k = 2 (max agg order = 4)
baseL2k2 <- rbind(rnorm(3*2, 5), rnorm(3*2, 5))

# Same weights for different forecast horizons, agg_order = 4
fix_weights <- matrix(runif(4*4), 4, 4)
reco <- ctmo(base = baseL2k2, id_rows = 2:3, agg_mat = A,
             order = 2, agg_order = 4, weights = fix_weights)

# Different weights for different forecast horizons
h_weights <- matrix(runif(4*4*3), 4, 3*4)
recoh <- ctmo(base = baseL2k2, id_rows = 2:3, agg_mat = A,
             order = 2, agg_order = 4, weights = h_weights)

}
\seealso{
Middle-out reconciliation: 
\code{\link{csmo}()},
\code{\link{temo}()}

Cross-temporal framework: 
\code{\link{ctboot}()},
\code{\link{ctbu}()},
\code{\link{ctcov}()},
\code{\link{ctlcc}()},
\code{\link{ctrec}()},
\code{\link{cttd}()},
\code{\link{cttools}()},
\code{\link{iterec}()},
\code{\link{tcsrec}()}
}
\concept{Framework: cross-temporal}
\concept{Reco: middle-out}
