% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun_export.R
\name{aggts}
\alias{aggts}
\title{Non-overlapping temporal aggregation of a time series}
\usage{
aggts(y, agg_order, tew = "sum", align = "end", rm_na = FALSE)
}
\arguments{
\item{y}{Univariate or multivariate time series: a vector/matrix or a \code{ts} object.}

\item{agg_order}{A numeric vector with the aggregation orders to consider.}

\item{tew}{A string specifying the type of temporal aggregation. Options include:
"\code{sum}" (simple summation, \emph{default}), "\code{avg}" (average),
"\code{first}" (first value of the period), and "\code{last}"
(last value of the period).}

\item{align}{A string or a vector specifying the alignment of \code{y}. Options include:
"\code{end}" (end of the series, \emph{default}), "\code{start}" (start of the series),
an integer (or a vector of integers) indicating the starting period of the temporally
aggregated series.}

\item{rm_na}{If \code{TRUE} the missing values are removed.}
}
\value{
A list of vectors or \code{ts} objects.
}
\description{
Non-overlapping temporal aggregation of a time series according
to a specific aggregation order.
}
\examples{
# Monthly time series (input vector)
y <- ts(rnorm(24), start = 2020, frequency = 12)
# Quarterly time series
x1 <- aggts(y, 3)
# Monthly, quarterly and annual time series
x2 <- aggts(y, c(1, 3, 12))
# All temporally aggregated time series
x3 <- aggts(y)

# Ragged data
y2 <- ts(rnorm(11), start = c(2020, 3), frequency = 4)
# Annual time series: start in 2021
x4 <- aggts(y2, 4, align = 3)
# Semi-annual (start in 2nd semester of 2020) and annual (start in 2021) time series
x5 <- aggts(y2, c(2, 4), align = c(1, 3))

}
\seealso{
Utilities: 
\code{\link{FoReco2matrix}()},
\code{\link{balance_hierarchy}()},
\code{\link{commat}()},
\code{\link{csprojmat}()},
\code{\link{cstools}()},
\code{\link{ctprojmat}()},
\code{\link{cttools}()},
\code{\link{df2aggmat}()},
\code{\link{lcmat}()},
\code{\link{recoinfo}()},
\code{\link{res2matrix}()},
\code{\link{set_bounds}()},
\code{\link{shrink_estim}()},
\code{\link{shrink_oasd}()},
\code{\link{teprojmat}()},
\code{\link{tetools}()},
\code{\link{unbalance_hierarchy}()}
}
\concept{Utilities}
