% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fedirt_2PL.R
\name{logL}
\alias{logL}
\title{Log-Likelihood of the federated 2PL Model}
\usage{
logL(a, b, data, q = 21, lower_bound = -3, upper_bound = 3)
}
\arguments{
\item{a}{The vector of item discrimination parameters in the 2PL model.}

\item{b}{The vector of item difficulty parameters in the 2PL model.}

\item{data}{The matrix of observed responses, with individuals in rows and items in columns.}

\item{q}{The number of Gaussian quadrature points to use for numerical integration (default is 21). Gaussian quadrature is a numerical integration technique to approximate the integral of a function, and is particularly useful for accurate and efficient computation.}

\item{lower_bound}{The lower limit for the Gaussian quadrature integration (default is -3).}

\item{upper_bound}{The upper limit for the Gaussian quadrature integration (default is 3).}
}
\value{
The computed log-likelihood of the 2PL model as a single numeric value.
}
\description{
Computes the log-likelihood of the Two-Parameter Logistic (2PL) IRT model given item parameters and response data. The computation utilizes numerical integration and is optimized through memoization for repeated evaluations.
}
\details{
The function performs numerical integration over a set of quadrature points to calculate the probabilities of the observed responses under the 2PL model, considering the item discrimination (a) and difficulty (b) parameters. Memoization is used to cache computed values of the probabilities, logits, and log-likelihoods to avoid redundant calculations and speed up the process.
}
