% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihoods.R
\name{fbms.mlik.master}
\alias{fbms.mlik.master}
\title{Master Log Marginal Likelihood Function}
\usage{
fbms.mlik.master(
  y,
  x,
  model,
  complex,
  mlpost_params = list(family = "gaussian", beta_prior = list(type = "g-prior"), r =
    NULL)
)
}
\arguments{
\item{y}{A numeric vector containing the dependent variable.}

\item{x}{A matrix containing the precalculated features (independent variables).}

\item{model}{A logical vector indicating which variables to include in the model.}

\item{complex}{A list of complexity measures for the features.}

\item{mlpost_params}{A list of parameters controlling the model family, prior, and tuning parameters.
Key elements include:
\itemize{
\item family: "binomial", "poisson", "gamma" (all three referred to as GLM below), or "gaussian" (default: "gaussian")
\item prior_beta: Type of prior as a string (default: "g-prior"). Possible values include:
\itemize{
\item "beta.prime": Beta-prime prior (GLM/Gaussian, no additional args)
\item "CH": Compound Hypergeometric prior (GLM/Gaussian, requires \code{a}, \code{b}, optionally \code{s})
\item "EB-local": Empirical Bayes local prior (GLM/Gaussian, requires \code{a} for Gaussian)
\item "EB-global": Empirical Bayes local prior (Gaussian, requires \code{a} for Gaussian)
\item "g-prior": Zellner's g-prior (GLM/Gaussian, requires \code{g})
\item "hyper-g": Hyper-g prior (GLM/Gaussian, requires \code{a})
\item "hyper-g-n": Hyper-g/n prior (GLM/Gaussian, requires \code{a})
\item "tCCH": Truncated Compound Hypergeometric prior (GLM/Gaussian, requires \code{a}, \code{b}, \code{s}, \code{rho}, \code{v}, \code{k})
\item "intrinsic": Intrinsic prior (GLM/Gaussian, no additional args)
\item "TG": Truncated Gamma prior (GLM/Gamma, requires \code{a}, \code{s})
\item "Jeffreys": Jeffreys prior (GLM/Gaussian, no additional args)
\item "uniform": Uniform prior (GLM/Gaussian, no additional args)
\item "benchmark": Benchmark prior (Gaussian/GLM, no additional args)
\item "ZS-adapted": Zellner-Siow adapted prior (Gaussian TCCH, no additional args)
\item "robust": Robust prior (Gaussian/GLM, no additional args)
\item "Jeffreys-BIC": Jeffreys prior with BIC approximation of marginal likelihood (Gaussian/GLM)
\item "ZS-null": Zellner-Siow null prior (Gaussian, requires \code{a})
\item "ZS-full": Zellner-Siow full prior (Gaussian, requires \code{a})
\item "hyper-g-laplace": Hyper-g Laplace prior (Gaussian, requires \code{a})
\item "AIC": AIC prior from BAS (Gaussian, requires penalty \code{a})
\item "BIC": BIC prior from BAS (Gaussian/GLM)
\item "JZS": Jeffreys-Zellner-Siow prior (Gaussian, requires \code{a})
}
\item r: Model complexity penalty (default: 1/n)
\item a: Tuning parameter for g-prior (default: max(n, p^2))
\item a, b, s, v, rho, k: Hyperparameters for various priors
\item n: Sample size for some priors (default: length(y))
\item var: Variance assumption for Gaussian models ("known" or "unknown", default: "unknown")
\item laplace: Logical for Laplace approximation in GLM only (default: FALSE)
}}
}
\value{
A list with elements:
\item{crit}{Log marginal likelihood combined with the log prior.}
\item{coefs}{Posterior mode of the coefficients.}
}
\description{
This function serves as a unified interface to compute the log marginal likelihood
for different regression models and priors by calling specific log likelihood functions.
}
\examples{
fbms.mlik.master(y = rnorm(100), 
x = matrix(rnorm(100)), 
c(TRUE,TRUE), 
list(oc = 1),
mlpost_params = list(family = "gaussian", beta_prior = list(type = "g-prior", a = 2),
         r = exp(-0.5)))

}
