% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{calculate_Exp}
\alias{calculate_Exp}
\title{Calculate Hourly Mosquito Biting Exposure for Bednet Users and Non-Users}
\usage{
calculate_Exp(df, df_bites, protection = 0.92)
}
\arguments{
\item{df}{A dataframe with individual-level data, including columns:
\itemize{
\item \code{individual} – individual ID,
\item \code{hour} – hour of the day (0–23),
\item \code{state} – activity/location state (1 = outdoors, 2 = indoors awake,
3 = indoors asleep, 4 = indoors asleep under bed net),
\item \code{bednet_user} – logical indicator of bed net use (TRUE/FALSE).
}}

\item{df_bites}{A dataframe of biting rates by hour, with columns:
\itemize{
\item \code{hour} – hour of the day (0–23),
\item \code{indoor_bites} – number of bites indoors,
\item \code{outdoor_bites} – number of bites outdoors.
}}

\item{protection}{A numeric value (default = 0.92, according to \insertCite{corbelFieldEfficacyNew2010;textual}{ExpBites} for Permanet 2 ITNs) indicating the proportion of bites prevented by bednet use.}
}
\value{
A dataframe with one row per hour (0–23) and the following columns:
\itemize{
\item \code{Bi_t} – indoor biting rate,
\item \code{Bo_t} – outdoor biting rate,
\item \code{N} – number of human individuals,
\item \code{Np} – number of human individuals that are net users,
\item \code{It} – proportion of people indoors (users and non-users),
\item \code{Eui} – mean exposure of non-users indoors,
\item \code{Euo} – mean exposure of non-users outdoors,
\item \code{Eu} – total mean exposure of non-users,
\item \code{p_in} – proportion of people (users) being indoors,
\item \code{p_net} – proportion of people (users) being asleep (under net),
\item \code{Epi} – mean exposure of users indoors (not under net),
\item \code{Epn} – mean exposure of users indoors under bed net (adjusted by protection),
\item \code{Epo} – mean exposure of users outdoors,
\item \code{Epp} – mean exposure prevented by bed net use,
\item \code{Ep} – total mean exposure of users.
}
}
\description{
Using a model of behavioral interactions, computes the hourly exposure to mosquito bites for both bednet users and non-users,
based on their location (indoors, outdoors, under a net) and mosquito biting rates.
For users, exposure is adjusted for the protective effect of bednets.
}
\details{
The mathematical model of behavioral interactions is an extension of the \insertCite{killeenQuantifyingBehaviouralInteractions2006;textual}{ExpBites} model as previously described in \insertCite{geissbuhlerInterdependenceDomesticMalaria2007;textual}{ExpBites} and \insertCite{moirouxHumanExposureEarly2014;textual}{ExpBites}
}
\examples{
# generate fake data 
df <- gen_df_human(n_individuals = 100, hours = c(0:9,17:23))
df_bites <- gen_df_mosquito() 
# calculate mean hourly exposure to bites
exposure_results <- calculate_Exp(df, df_bites)

}
\references{
\insertAllCited{}
}
