% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ray.quot.seceig.tri.R
\name{ray.quot.seceig.tri}
\alias{ray.quot.seceig.tri}
\title{Rayleigh quotient iteration for Tridiagonal matrix}
\usage{
ray.quot.seceig.tri(Q, mu, v0_tilde, zstart, digit.thresh = 6)
}
\arguments{
\item{Q}{The input matrix to find the maximal eigenpair.}

\item{mu}{A vector.}

\item{v0_tilde}{The unnormalized initial vector \eqn{\tilde{v0}}.}

\item{zstart}{The initial \eqn{z_0} as an approximation of \eqn{\rho(Q)}.}

\item{digit.thresh}{The precise level of output results.}
}
\value{
A list of eigenpair object are returned, with components \eqn{z}, \eqn{v} and \eqn{iter}.
\item{z}{The approximating sequence of the maximal eigenvalue.}
\item{v}{The approximating eigenfunction of the corresponding eigenvector.}
\item{iter}{The number of iterations.}
}
\description{
Rayleigh quotient iteration algorithm to computing the next to 
maximal eigenpair of tridiagonal matrix Q.
}
\examples{
a = c(1:7)^2
b = c(1:7)^2
c = rep(0, length(a) + 1)
c[length(a) + 1] = 8^2
N = length(a)
Q = tridiag(b, a, -c(b[1] + c[1], a[1:N - 1] + b[2:N] + c[2:N], a[N] + c[N + 1]))
ray.quot.seceig.tri(Q, mu=rep(1,dim(Q)[1]), v0_tilde=rep(1,dim(Q)[1]), zstart=6,
 digit.thresh = 6)
}
