% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_to_excel.R
\name{edc_db_to_excel}
\alias{edc_db_to_excel}
\alias{edc_browse_excel}
\title{Save the database as an Excel file}
\usage{
edc_db_to_excel(
  filename = tempfile(fileext = ".xlsx"),
  ...,
  datasets = get_datasets(),
  overwrite = FALSE,
  open = FALSE
)

edc_browse_excel()
}
\arguments{
\item{filename}{the path to the Excel output file. Default to a temporary file. Use the special value \code{TRUE} to save in "data/database_\{date_extraction\}.xlsx".}

\item{...}{unused}

\item{datasets}{a named list of dataframes. Default to the TM export.}

\item{overwrite}{whether to overwrite any existing file. Default to \code{FALSE}.}

\item{open}{whether to open the Excel file afterward. Default to \code{FALSE}.}
}
\value{
nothing
}
\description{
Because RStudio is not very good at showing data, it can be more convenient to browse the
database using MS Excel. This function turns the whole TM export (or any named list of datasets)
into an Excel workbook, with one tab for each dataset.\cr
Use \code{edc_db_to_excel()} to create the file and \code{edc_browse_excel()} to open it.
}
\examples{
\dontrun{
  db = edc_example()
  load_database(db)  
  edc_db_to_excel() #default arguments are usually OK
  edc_db_to_excel(filename=TRUE)
}
}
