% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseProportionOfPatientsCovered.R
\name{summariseProportionOfPatientsCovered}
\alias{summariseProportionOfPatientsCovered}
\title{Summarise proportion Of patients covered}
\usage{
summariseProportionOfPatientsCovered(
  cohort,
  cohortId = NULL,
  strata = list(),
  followUpDays = NULL
)
}
\arguments{
\item{cohort}{A cohort_table object.}

\item{cohortId}{A cohort definition id to restrict by. If NULL, all cohorts
will be included.}

\item{strata}{A list of variables to stratify results. These variables
must have been added as additional columns in the cohort table.}

\item{followUpDays}{Number of days to follow up individuals for. If NULL the
maximum amount of days from an individuals first cohort start date to their
last cohort end date will be used}
}
\value{
A summarised result
}
\description{
Gives the proportion of patients still in observation who are
in the cohort on any given day following their first cohort entry. This is
known as the “proportion of patients covered” (PPC) method for assessing
treatment persistence.
}
\examples{
\donttest{
library(DrugUtilisation)

cdm <- mockDrugUtilisation(numberIndividuals = 100)

result <- cdm$cohort1 |>
  summariseProportionOfPatientsCovered(followUpDays = 365)

tidy(result)
}

}
