% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_codes.R
\encoding{UTF-8}
\name{list_codes}
\alias{list_codes}
\title{Look Up Administrative Codes (AGS) for German Regions}
\usage{
list_codes(year)
}
\arguments{
\item{year}{Integer. Year of the geodata (must be between 1998 and 2022).}
}
\value{
A \code{DT::datatable} object showing merged geospatial metadata with municipality, district, and state names and their respective AGS codes.
}
\description{
Displays an interactive table for identifying official administrative codes (AGS) of municipalities (Gemeinden), districts (Kreise), and federal states (Länder) in Germany. The function loads and processes shapefiles for a given year, merges them across administrative levels, and presents a searchable datatable with names and AGS codes for each region.
}
\examples{
\donttest{
list_codes(year = 2022)
}
}
