% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Covrg.R
\name{Covrg}
\alias{Covrg}
\title{Coverage Probabilities for Confidence Intervals about alpha, for fixed true alpha}
\usage{
Covrg(marg, alph, scal = log(2 * marg[3]^2), lev = 0.95)
}
\arguments{
\item{marg}{a 3-entry integer vector (mA,mB,N) consisting of the first row and column totals and the table total for a 2x2 contingency table}

\item{alph}{True log-odds-ratio value alpha at which coverage probabilities (under Extended Hypergeometric with parameters mA,mB,N, exp(alp)) are to be calculated}

\item{scal}{an integer parameter (default 2*N^2, capped at 10 within the function) that should be 2 or greater}

\item{lev}{a confidence level, generally somewhere from 0.8 to 0.95 (default 0.95)}
}
\value{
A vector covPrb containing the coverage propbabilities for the four Confidence Intervals
}
\description{
This function calculates the coverage probability at the true value alpha of the four types of Cpnfidence Intervals (CI.CP, CI.Blaker, CI.midQ, CI.midP) computed in AlphInts().
}
\details{
See AlphInts() documentation for details of computation of the four confidence intervals CI.CP, CI.Blaker, CI.midQ, CI.midP. The confidence intervals are calculated for each x in the allowed range from max(mA+mB-N,0) to min(mA,mB), and the probability that X=x times the indicator of alph falling in each of them is summed.
}
\examples{
Covrg(c(50,70,150), 1.2, lev=0.95)
Covrg(c(50,70,150), 0, lev=0.95)
Covrg(c(50,80,120), 1.5, lev=0.9)
}
\references{
to be added
}
\author{
Eric Slud
}
