#' Darwin’s finches presence–absence data
#'
#' A presence (1)/absence (0) matrix of seven Darwin’s finch species
#' across 13 Galápagos Islands.
#'
#' @format A data frame with 7 rows (Darwin’s finch species, in the row names) and 17 columns (Galápagos Islands):
#' \describe{
#'   \item{Baltra}{presence (1) or absence (0)}
#'   \item{Darwin}{presence (1) or absence (0)}
#'   \item{Espanola}{presence (1) or absence (0)}
#'   \item{Fernandina}{presence (1) or absence (0)}
#'   \item{Floreana}{presence (1) or absence (0)}
#'   \item{Genovesa}{presence (1) or absence (0)}
#'   \item{Isabella}{presence (1) or absence (0)}
#'   \item{Marchena}{presence (1) or absence (0)}
#'   \item{Pinta}{presence (1) or absence (0)}
#'   \item{Pinzon}{presence (1) or absence (0)}
#'   \item{Rabida}{presence (1) or absence (0)}
#'   \item{San.Cristobal}{presence (1) or absence (0)}
#'   \item{Santa.Cruz}{presence (1) or absence (0)}
#'   \item{Santa.Fe}{presence (1) or absence (0)}
#'   \item{Santiago}{presence (1) or absence (0)}
#'   \item{Seymour}{presence (1) or absence (0)}
#'   \item{Wolf}{presence (1) or absence (0)}
#' }
#' @details
#' Row names are the seven species: Geospiza magnirostris, G. fortis,
#' G. fuliginosa, G. difficilis, G. scandens, G. conirostris, and G. fuliginosa.
#'
#' @source
#' Sanderson J.G. (2000) Testing ecological patterns: a well‐known algorithm
#'   from computer science aids the evaluation of species distributions.
#'   *American Scientist* 88, 332–339.
#'
#' Griffith D.M., Veech J.A., Marsh C.J. (2016) *cooccur*: probabilistic species
#'   co‐occurrence analysis in R. *Methods in Ecology and Evolution* 7, 539–543.
#'
"finches"
