% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.catatis.R
\name{plot.catatis}
\alias{plot.catatis}
\title{Displays the CATATIS graphs}
\usage{
\method{plot}{catatis}(x, Graph=TRUE, Graph_weights=TRUE, Graph_eig=TRUE,
  axes=c(1,2), tit="CATATIS", cex=1, col.obj="blue", col.attr="red", ...)
}
\arguments{
\item{x}{object of class 'catatis'}

\item{Graph}{logical. Show the graphical representation? Default: TRUE}

\item{Graph_weights}{logical. Should the barplot of the weights be plotted? Default: TRUE}

\item{Graph_eig}{logical. Should the barplot of the eigenvalues be plotted? Only with Graph=TRUE. Default: TRUE}

\item{axes}{numerical vector (length 2). Axes to be plotted}

\item{tit}{string. Title for the graphical representation. Default: 'CATATIS'}

\item{cex}{numerical. Numeric character expansion factor; multiplied by par("cex") yields the final character size. NULL and NA are equivalent to 1.0.}

\item{col.obj}{numerical or string. Color for the objects points. Default: "blue"}

\item{col.attr}{numerical or string. Color for the attributes points. Default: "red"}

\item{...}{further arguments passed to or from other methods}
}
\value{
the CATATIS map
}
\description{
This function plots the CATATIS map and CATATIS weights
}
\examples{
 \donttest{
data(straw)
res.cat=catatis(straw, nblo=114)
plot(res.cat, Graph_weights=FALSE, axes=c(1,3))
}

}
\seealso{
\code{\link{catatis}}
}
\keyword{CATA}
\keyword{RATA}
