% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connection.R
\docType{class}
\name{ClickHouseHTTPConnection-class}
\alias{ClickHouseHTTPConnection-class}
\alias{dbSendQuery,ClickHouseHTTPConnection,character-method}
\alias{dbGetInfo,ClickHouseHTTPConnection-method}
\alias{dbListTables,ClickHouseHTTPConnection-method}
\alias{dbExistsTable,ClickHouseHTTPConnection,character-method}
\alias{dbReadTable,ClickHouseHTTPConnection,character-method}
\alias{dbListFields,ClickHouseHTTPConnection,character-method}
\alias{dbRemoveTable,ClickHouseHTTPConnection,ANY-method}
\alias{dbCreateTable,ClickHouseHTTPConnection-method}
\alias{dbAppendTable,ClickHouseHTTPConnection-method}
\alias{dbWriteTable,ClickHouseHTTPConnection,ANY-method}
\title{ClickHouseHTTPConnection class.}
\usage{
\S4method{dbSendQuery}{ClickHouseHTTPConnection,character}(
  conn,
  statement,
  format = c("Arrow", "TabSeparatedWithNamesAndTypes"),
  file = NA,
  ...
)

\S4method{dbGetInfo}{ClickHouseHTTPConnection}(dbObj, ...)

\S4method{dbListTables}{ClickHouseHTTPConnection}(conn, database = NA, ...)

\S4method{dbExistsTable}{ClickHouseHTTPConnection,character}(conn, name, database = NA, ...)

\S4method{dbReadTable}{ClickHouseHTTPConnection,character}(conn, name, database = NA, ...)

\S4method{dbListFields}{ClickHouseHTTPConnection,character}(conn, name, database = NA, ...)

\S4method{dbRemoveTable}{ClickHouseHTTPConnection,ANY}(conn, name, database = NA, ...)

\S4method{dbCreateTable}{ClickHouseHTTPConnection}(
  conn,
  name,
  database = NA,
  fields,
  engine = "TinyLog",
  overwrite = FALSE,
  ...,
  row.names = NULL,
  temporary = FALSE
)

\S4method{dbAppendTable}{ClickHouseHTTPConnection}(conn, name, database = NA, value, ..., row.names = NULL)

\S4method{dbWriteTable}{ClickHouseHTTPConnection,ANY}(
  conn,
  name,
  database = NA,
  value,
  overwrite = FALSE,
  append = FALSE,
  engine = "TinyLog",
  ...
)
}
\arguments{
\item{conn}{a ClickHouseHTTPConnection object created
with \code{\link[=ClickHouseHTTPDriver-class]{dbConnect()}}}

\item{statement}{the SQL query statement}

\item{format}{the format used by ClickHouse to send the results.
Two formats are supported:
"Arrow" (default) and "TabSeparatedWithNamesAndTypes"}

\item{file}{a path to a file to send along the query (default: NA)}

\item{...}{Other parameters passed on to methods}

\item{dbObj}{a ClickHouseHTTPConnection object}

\item{database}{the database to consider. If NA (default), the default
database or  the one in use in the session (if a session is defined).}

\item{name}{the name of the table to create}

\item{fields}{a character vector with the name of the fields and their
ClickHouse type
(e.g.
\code{c("text_col String", "num_col Nullable(Float64)", "nul_col Array(Int32)")}
)}

\item{engine}{the ClickHouse table engine as described in ClickHouse
\href{https://clickhouse.com/docs/en/engines/table-engines/}{documentation}.
Examples:
\itemize{
\item \code{"TinyLog"} (default)
\item \code{"MergeTree() ORDER BY (expr)"}
(expr generally correspond to fields separated by ",")
}}

\item{overwrite}{if TRUE and if a table with the same name exists,
then it is deleted before creating the new one (default: FALSE)}

\item{row.names}{unsupported parameter (add for compatibility reason)}

\item{temporary}{unsupported parameter (add for compatibility reason)}

\item{value}{a data.frame}

\item{append}{if TRUE, the values are added to the database table if
it exists (default: FALSE).}
}
\value{
A ClickHouseHTTPResult object

A list with the following elements:
\itemize{
\item name: "ClickHouseHTTPConnection"
\item db.version: the version of ClickHouse
\item uptime: ClickHouse uptime
\item dbname: the default database
\item username: user name
\item host: ClickHouse host
\item port: ClickHouse port
\item https: Is the connection using HTTPS protocol instead of HTTP
}

A vector of character with table names.

A logical.

A data.frame.

A vector of character with column names.

\code{invisible(TRUE)}

dbCreateTable() returns TRUE, invisibly.

\code{invisible(TRUE)}

TRUE; called for side effects
}
\description{
ClickHouseHTTPConnection class.

Send SQL query to ClickHouse

Information about the ClickHouse database

List tables in ClickHouse

Does a table exist?

Read database tables as data frames

List field names of a table

Remove a table from the database

Create a table in ClickHouse

Insert rows into a table

Write a table in ClickHouse
}
\details{
Both format have their pros and cons:
\itemize{
\item \strong{Arrow} (default):
\itemize{
\item fast for long tables but slow for wide tables
\item fast with Array columns
\item Date and DateTime columns are returned as UInt16 and UInt32
respectively: by default, ClickHouseHTTP interpret them as Date and
POSIXct columns but cannot make the difference with actual UInt16 and
UInt32
}
\item \strong{TabSeparatedWithNamesAndTypes}:
\itemize{
\item in general faster than Arrow
\item fast for wide tables but slow for long tables
\item slow with Array columns
\item Special characters are not well interpreted. In such cases, the function
below can be useful but can also take time.
}
}

\preformatted{
      .sp_ch_recov <- function(x){
         stringi::stri_replace_all_regex(
            x,
            c(
               "\\\\n", "\\\\t",  "\\\\r", "\\\\b",
               "\\\\a", "\\\\f", "\\\\'",  "\\\\\\\\"
            ),
            c("\n", "\t", "\r", "\b", "\a", "\f", "'", "\\\\"),
            vectorize_all=FALSE
         )
      }
}
}
\examples{
\dontrun{
## Connection ----

library(DBI)
### HTTP connection ----

con <- dbConnect(
  ClickHouseHTTP::ClickHouseHTTP(),
  host = "localhost",
  port = 8123
)

### HTTPS connection (without ssl peer verification) ----

con <- dbConnect(
  ClickHouseHTTP::ClickHouseHTTP(),
  host = "localhost",
  port = 8443,
  https = TRUE,
  ssl_verifypeer = FALSE
)

## Write a table in the database ----

library(dplyr)
data("mtcars")
mtcars <- as_tibble(mtcars, rownames = "car")
dbWriteTable(con, "mtcars", mtcars)

## Query the database ----

carsFromDB <- dbReadTable(con, "mtcars")
dbGetQuery(con, "SELECT car, mpg, cyl, hp FROM mtcars WHERE hp>=110")

## By default, ClickHouseHTTP relies on the
## Apache Arrow format provided by ClickHouse.
## The `format` argument of the `dbGetQuery()` function can be used to
## rely on the *TabSeparatedWithNamesAndTypes* format.
selCars <- dbGetQuery(
  con,
  "SELECT car, mpg, cyl, hp FROM mtcars WHERE hp>=110",
  format = "TabSeparatedWithNamesAndTypes"
)
## Identifying the original ClickHouse data types
attr(selCars, "type")

## Using alternative databases stored in ClickHouse ----

dbSendQuery(con, "CREATE DATABASE swiss")
dbSendQuery(con, "USE swiss")

## The chosen database is used until the session expires.
## It can also be chosen when connecting using the `dbname` argument of
## the `dbConnect()` function.

## The example below shows that spaces in column names are supported.
## It also shows the support of R `list` using the *Array* ClickHouse type.
data("swiss")
swiss <- as_tibble(swiss, rownames = "province")
swiss <- mutate(swiss, "pr letters" = strsplit(province, ""))
dbWriteTable(
  con,
  "swiss",
  swiss,
  engine = "MergeTree() ORDER BY (Fertility, province)"
)
swissFromDB <- dbReadTable(con, "swiss")

## A table from another database can also be accessed as following:
dbReadTable(con, SQL("default.mtcars"))

}
\dontrun{
## Connection ----

library(DBI)
### HTTP connection ----

con <- dbConnect(
  ClickHouseHTTP::ClickHouseHTTP(),
  host = "localhost",
  port = 8123
)

### HTTPS connection (without ssl peer verification) ----

con <- dbConnect(
  ClickHouseHTTP::ClickHouseHTTP(),
  host = "localhost",
  port = 8443,
  https = TRUE,
  ssl_verifypeer = FALSE
)

## Write a table in the database ----

library(dplyr)
data("mtcars")
mtcars <- as_tibble(mtcars, rownames = "car")
dbWriteTable(con, "mtcars", mtcars)

## Query the database ----

carsFromDB <- dbReadTable(con, "mtcars")
dbGetQuery(con, "SELECT car, mpg, cyl, hp FROM mtcars WHERE hp>=110")

## By default, ClickHouseHTTP relies on the
## Apache Arrow format provided by ClickHouse.
## The `format` argument of the `dbGetQuery()` function can be used to
## rely on the *TabSeparatedWithNamesAndTypes* format.
selCars <- dbGetQuery(
  con,
  "SELECT car, mpg, cyl, hp FROM mtcars WHERE hp>=110",
  format = "TabSeparatedWithNamesAndTypes"
)
## Identifying the original ClickHouse data types
attr(selCars, "type")

## Using alternative databases stored in ClickHouse ----

dbSendQuery(con, "CREATE DATABASE swiss")
dbSendQuery(con, "USE swiss")

## The chosen database is used until the session expires.
## It can also be chosen when connecting using the `dbname` argument of
## the `dbConnect()` function.

## The example below shows that spaces in column names are supported.
## It also shows the support of R `list` using the *Array* ClickHouse type.
data("swiss")
swiss <- as_tibble(swiss, rownames = "province")
swiss <- mutate(swiss, "pr letters" = strsplit(province, ""))
dbWriteTable(
  con,
  "swiss",
  swiss,
  engine = "MergeTree() ORDER BY (Fertility, province)"
)
swissFromDB <- dbReadTable(con, "swiss")

## A table from another database can also be accessed as following:
dbReadTable(con, SQL("default.mtcars"))

}
\dontrun{
## Connection ----

library(DBI)
### HTTP connection ----

con <- dbConnect(
  ClickHouseHTTP::ClickHouseHTTP(),
  host = "localhost",
  port = 8123
)

### HTTPS connection (without ssl peer verification) ----

con <- dbConnect(
  ClickHouseHTTP::ClickHouseHTTP(),
  host = "localhost",
  port = 8443,
  https = TRUE,
  ssl_verifypeer = FALSE
)

## Write a table in the database ----

library(dplyr)
data("mtcars")
mtcars <- as_tibble(mtcars, rownames = "car")
dbWriteTable(con, "mtcars", mtcars)

## Query the database ----

carsFromDB <- dbReadTable(con, "mtcars")
dbGetQuery(con, "SELECT car, mpg, cyl, hp FROM mtcars WHERE hp>=110")

## By default, ClickHouseHTTP relies on the
## Apache Arrow format provided by ClickHouse.
## The `format` argument of the `dbGetQuery()` function can be used to
## rely on the *TabSeparatedWithNamesAndTypes* format.
selCars <- dbGetQuery(
  con,
  "SELECT car, mpg, cyl, hp FROM mtcars WHERE hp>=110",
  format = "TabSeparatedWithNamesAndTypes"
)
## Identifying the original ClickHouse data types
attr(selCars, "type")

## Using alternative databases stored in ClickHouse ----

dbSendQuery(con, "CREATE DATABASE swiss")
dbSendQuery(con, "USE swiss")

## The chosen database is used until the session expires.
## It can also be chosen when connecting using the `dbname` argument of
## the `dbConnect()` function.

## The example below shows that spaces in column names are supported.
## It also shows the support of R `list` using the *Array* ClickHouse type.
data("swiss")
swiss <- as_tibble(swiss, rownames = "province")
swiss <- mutate(swiss, "pr letters" = strsplit(province, ""))
dbWriteTable(
  con,
  "swiss",
  swiss,
  engine = "MergeTree() ORDER BY (Fertility, province)"
)
swissFromDB <- dbReadTable(con, "swiss")

## A table from another database can also be accessed as following:
dbReadTable(con, SQL("default.mtcars"))

}
}
\seealso{
\linkS4class{ClickHouseHTTPResult}
}
