% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cepstral.R
\name{effect_get}
\alias{effect_get}
\title{Compute Functional Effects of Intercept and Covariates}
\usage{
effect_get(alpha, beta, frq, nbase, ind)
}
\arguments{
\item{alpha}{A numeric vector of cepstral intercept coefficients.}

\item{beta}{A numeric matrix of regression coefficients.}

\item{frq}{Numeric vector of frequency points in \code{[0,1]}.}

\item{nbase}{Number of Fourier basis functions.}

\item{ind}{An integer vector indicating the indices of covariates to be included in the model.}
}
\value{
A list containing:
\describe{
\item{\code{alpha_effect}}{Functional intercept across frequency.}
\item{\code{beta_effect}}{Matrix of functional covariate effects.}
}
}
\description{
Projects cepstral coefficient intercept and covariate effects onto the frequency domain
using the cepstral basis functions.
}
\examples{
frq <- seq(0, 1, length.out = 16)[2:8]
alpha <- rnorm(3)
beta <- matrix(rnorm(2 * 3), 2, 3)
result <- effect_get(alpha, beta, frq, nbase = 3, ind = c(1, 2))

}
