% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CardioCurveR-package.R
\docType{package}
\name{CardioCurveR-package}
\alias{CardioCurveR-package}
\title{CardioCurveR: Nonlinear Modeling of R-R Interval Dynamics}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Automated and robust framework for analyzing R-R interval (RRi) signals using advanced nonlinear modeling and preprocessing techniques. The package implements a dual-logistic model to capture the rapid drop and subsequent recovery of RRi during exercise, as described by Castillo-Aguilar et al. (2025) \doi{10.1038/s41598-025-93654-6}. In addition, 'CardioCurveR' includes tools for filtering RRi signals using zero-phase Butterworth low-pass filtering and for cleaning ectopic beats via adaptive outlier replacement using local regression and robust statistics. These integrated methods preserve the dynamic features of RRi signals and facilitate accurate cardiovascular monitoring and clinical research.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/matcasti/CardioCurveR}
  \item \url{https://matcasti.github.io/CardioCurveR/}
  \item Report bugs at \url{https://github.com/matcasti/CardioCurveR/issues}
}

}
\author{
\strong{Maintainer}: Matías Castillo-Aguilar \email{m99castillo@gmail.com} (\href{https://orcid.org/0000-0001-7291-247X}{ORCID}) [copyright holder]

}
\keyword{internal}
