% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAC2.R
\name{MAC2}
\alias{MAC2}
\title{Internal function for the Meta-Analytical Calibration Curve (MAC2)}
\usage{
MAC2(
  data = NULL,
  p,
  y,
  cluster,
  grid,
  cl.level = 0.95,
  alpha.lr = 0.05/3,
  plot = TRUE,
  cluster_curves = FALSE,
  knots = 3,
  transf = "logit",
  method_choice = c("splines", "log", "loess"),
  method.tau = "REML",
  prediction = TRUE,
  random = TRUE,
  sm = "PLOGIT",
  hakn = FALSE,
  linewidth = 1,
  method.predict = "HTS",
  verbose = FALSE
)
}
\arguments{
\item{data}{optional data frame containing the variables \code{p}, \code{y},
and \code{cluster}. If supplied, variable names should be given without
quotation marks.}

\item{p}{predicted probabilities (numeric vector) or name of the column in
\code{data}.}

\item{y}{binary outcome variable or the name of the column in \code{data}.}

\item{cluster}{Cluster identifier (factor, character, or integer) or name of
the column in \code{data}.}

\item{grid}{the grid for the calibration curve evaluation}

\item{cl.level}{the confidence level for the calculation of the confidence interval. Default is \code{0.95}.}

\item{alpha.lr}{the alpha-level used for the likelihood ratio test, selecting the number of knots for the
restricted cubic splines}

\item{plot}{logical, indicates whether to plot the calibration curves. Default is \code{TRUE}.}

\item{cluster_curves}{logical, whether to include cluster-specific curves in the plot. Default is \code{FALSE}.}

\item{knots}{integer, number of knots for splines. Default is \code{3}.}

\item{transf}{character, transformation for predictions: \code{"logit"} or \code{"identity"}. Default is \code{"logit"}.}

\item{method_choice}{character, which method to use for meta-analysis. Options are:
\code{"log"}, \code{"loess"} or \code{"splines"}. Default is \code{"splines"}.}

\item{method.tau}{character, method for between-study heterogeneity estimation. Default is \code{"REML"}.
This argument is passed to the  \code{\link[meta]{metagen}} function.}

\item{prediction}{logical, whether to compute prediction intervals. Default is \code{TRUE}.
This argument is passed to the  \code{prediction} argument of the \code{\link[meta]{metagen}} function.}

\item{random}{logical, whether to use random-effects model. Default is \code{TRUE}.
This argument is passed to the  \code{random} argument of the \code{\link[meta]{metagen}} function.}

\item{sm}{character, summary measure for meta-analysis. Default is \code{"PLOGIT"}.
This argument is passed to the  \code{sm} argument of the \code{\link[meta]{metagen}} function.}

\item{hakn}{logical, whether to use Hartung-Knapp adjustment. Default is \code{FALSE}.
This argument is passed to the  \code{method.random.ci} argument of the \code{\link[meta]{metagen}} function.}

\item{linewidth}{numeric, line width for the meta-curve. Default is \code{1}.}

\item{method.predict}{character, method for prediction intervals. Default is \code{"HTS"}.
This argument is passed to the  \code{method.predict} argument of the \code{\link[meta]{metagen}} function.}

\item{verbose}{logical, indicates whether progress has to be printed in the console.}
}
\value{
A list containing:
\describe{
  \item{\code{cluster_data}}{Data frame with linear predictors and standard errors for each method per cluster}
  \item{\code{plot_data}}{Data frame with meta-analysis results including predictions and intervals}
  \item{\code{plot}}{A \code{ggplot2} object if \code{plot = TRUE}, otherwise \code{NULL}}
}
}
\description{
Computes meta-analytical calibration curves using multiple methods (logistic regression,
loess or splines) and performs meta-analysis across clusters
to generate aggregated calibration curves with confidence and prediction intervals.
}
\details{
This function estimates the center-specific calibration curves using logistic regression,
loess or splines. Hereafter, it aggregates the calibration curves using meta-analytical techniques.
The meta-analysis is performed using the function \code{\link[meta]{metagen}} from the \code{\link[meta]{meta}}
package. The \code{method_choice} argument determines which method is for the meta-analytical aggregation.
}
